<?php /*?>https://developers.google.com/maps/documentation/javascript/examples/geocoding-simple<?php */?>

<!DOCTYPE html>
<html>
<head>
<title>Geocoding Service</title>
<meta name="viewport" content="initial-scale=1.0, user-scalable=no">
<meta charset="utf-8">
<style>
/* Always set the map height explicitly to define the size of the div
* element that contains the map. */
#map {
height: 100%;
}
/* Optional: Makes the sample page fill the window. */
html, body {
height: 100%;
margin: 0;
padding: 0;
}
#floating-panel {
position: absolute;
top: 10px;
left: 1%;
z-index: 5;
background-color: #fff;
padding: 5px;
border: 1px solid #999;
text-align: center;
font-family: 'Roboto','sans-serif';
line-height: 30px;
padding-left: 10px;
}
#floating-panel div {padding:5px;}
</style>
</head>
<body>
<div id="floating-panel">
<input id="address" type="textbox" value="2 s. new lane sioux falls">
<input id="submit" type="button" value="Search Address">

<br/>
<input type="button" name="button_clear_map" value="Clear Map" onClick="return clear_overlays()">
<input type="button" name="button_predefined_rectangle" value="Pre-Defined Rectangle" onClick="return predefined_rectangle(200,100)">
<br/>
<input type="button" name="button_predefined_circle" value="Pre-Defined Circle" onClick="return predefined_circle(100)">
<input type="button" name="button_predefined_triangle" value="Pre-Defined Triangle" onClick="return predefined_triangle(100,100)">
<br/>
<input type="button" name="button_predefined_semi_circle" value="Pre-Defined Semi-Circle" onClick="return predefined_semi_circle(100)">
<br/>

Area<br/>
<div style="height:170px; border:1px solid grey; text-align:left" id="container_display_area"></div>
Perimeter<br/>
<div style="height:100px; border:1px solid grey; text-align:left" id="container_display_perimeter"></div>
</div>

<div id="map"></div>

<script>

//
var map;
var drawingManager;
var markersArray = new Array();
//

//load map......................................................................................................................
function initMap() {

//
map = new google.maps.Map(document.getElementById('map'), {
zoom: 18,
center: {lat: 43.5427, lng: -96.6905},
mapTypeId: 'hybrid'
});

var geocoder = new google.maps.Geocoder();

//
document.getElementById('submit').addEventListener('click', function() {
geocodeAddress(geocoder, map);
});




//drawing manager.............................................................................................................
drawingManager = new google.maps.drawing.DrawingManager({
drawingMode: google.maps.drawing.OverlayType.MARKER,
drawingControl: true,
drawingControlOptions: {
position: google.maps.ControlPosition.TOP_CENTER,
drawingModes: ['circle', 'polygon', 'rectangle']
//drawingModes: ['marker', 'circle', 'polygon', 'polyline', 'rectangle']
},
markerOptions: {icon: 'https://developers.google.com/maps/documentation/javascript/examples/full/images/beachflag.png'},
markerOptions: {
  clickable: true,
  dragabble: true,
  editable: true
},
circleOptions: {
fillColor: '#000000',
fillOpacity: 0.3,
strokeColor: 'yellow',
strokeWeight: 1,
clickable: true,
editable: true,
draggable: true,
zIndex: 1
},
rectangleOptions: {
fillColor: '#000000',
fillOpacity: 0.3,
strokeColor: 'yellow',
strokeWeight: 1,
clickable: true,
editable: true,
draggable: true,
zIndex: 1
},
polygonOptions: {
fillColor: '#000000',
fillOpacity: 0.3,
strokeColor: 'yellow',
strokeWeight: 1,
clickable: true,
editable: true,
draggable: true,
zIndex: 1
}
});

//
drawingManager.setMap(map);


//area calculate#######################################################################
google.maps.event.addListener(drawingManager, 'overlaycomplete', function(event) {

//alert(event.type);
//.......................................................................
markersArray.push(event.overlay);
google.maps.event.addListener(event.overlay,"click",function(){});
//.......................................................................

//circle.....................................
if (event.type == 'circle') {
var radius = event.overlay.getRadius();
var area_meter_square=3.142*radius*radius;
var perimeter_meter=2*3.142*radius;
}
//end circle.....................................

//rectangle.....................................................................................
if (event.type == 'rectangle') 
{
/*area = google.maps.geometry.spherical.computeArea(event.overlay.getBounds());
alert("Area(in square meters) is approximately: "+area.toFixed(0));*/

//get lat/lng bounds of the current shape
var bounds = event.overlay.getBounds();
var sw = bounds.getSouthWest();
var ne = bounds.getNorthEast();
var southWest = new google.maps.LatLng(sw.lat(), sw.lng());
var northEast = new google.maps.LatLng(ne.lat(), ne.lng());
var southEast = new google.maps.LatLng(sw.lat(), ne.lng());
var northWest = new google.maps.LatLng(ne.lat(), sw.lng());
var area_meter_square=google.maps.geometry.spherical.computeArea([northEast, northWest, southWest, southEast]);
var perimeter_meter=google.maps.geometry.spherical.computeLength([northEast, northWest, southWest, southEast]);
//alert("Area(in square meters) is approximately: "+area.toFixed(0));

/*var bounds = event.overlay.getBounds();
var start = bounds.getNorthEast();
var end = bounds.getSouthWest();
var center = bounds.getCenter();
alert(start);*/

}
//end rectangle..................................................................................

//polygon.....................................................................................
if (event.type == 'polygon') 
{
area_meter_square = google.maps.geometry.spherical.computeArea(event.overlay.getPath());
perimeter_meter = google.maps.geometry.spherical.computeLength(event.overlay.getPath());
//alert("Area(in square meters) is approximately: "+polygonArea.toFixed(0));
}
//end polygon.................................................................................


//area
display_area(area_meter_square);
display_perimeter(perimeter_meter);



//after overlaycomplete listener for area change#################################################################################
//disable draw tool
drawingManager.setDrawingMode(null);
//Here the new code
var new_shape = event.overlay;

//alert(event.type);

//rectangle recalculate area------------------------------------------------------------------------------------------------
if(event.type=='rectangle')
{

google.maps.event.addListener(new_shape, "bounds_changed", function() {

//
var bounds = new_shape.getBounds();
var sw = bounds.getSouthWest();
var ne = bounds.getNorthEast();
var southWest = new google.maps.LatLng(sw.lat(), sw.lng());
var northEast = new google.maps.LatLng(ne.lat(), ne.lng());
var southEast = new google.maps.LatLng(sw.lat(), ne.lng());
var northWest = new google.maps.LatLng(ne.lat(), sw.lng());
var area_meter_square=google.maps.geometry.spherical.computeArea([northEast, northWest, southWest, southEast]);
var perimeter_meter=google.maps.geometry.spherical.computeLength([northEast, northWest, southWest, southEast]);
//

//area
display_area(area_meter_square);
display_perimeter(perimeter_meter);

});

//when clicked call bounds_changed
google.maps.event.addListener(new_shape, 'click', function(){
                              google.maps.event.trigger(this, 'bounds_changed');} );

}
//end if rectangle
//end rectangle recalculate area--------------------------------------------------------------------------------------------



//polygon recalculate area------------------------------------------------------------------------------------------------
if(event.type=='polygon')
{

google.maps.event.addListener(new_shape, "mouseup", function() {
//
area_meter_square = google.maps.geometry.spherical.computeArea(event.overlay.getPath());
perimeter_meter = google.maps.geometry.spherical.computeLength(event.overlay.getPath());
//

//area
display_area(area_meter_square);
display_perimeter(perimeter_meter);

});

}
//end if polygon
//end polygon recalculate area--------------------------------------------------------------------------------------------




//circle recalculate area------------------------------------------------------------------------------------------------
if(event.type=='circle')
{

google.maps.event.addListener(new_shape, "radius_changed", function() {

//
var radius = new_shape.getRadius();
var area_meter_square=3.142*radius*radius;
var perimeter_meter=2*3.142*radius;
//

//area
display_area(area_meter_square);
display_perimeter(perimeter_meter);

});

//when clicked call bounds_changed
google.maps.event.addListener(new_shape, 'click', function(){
                              google.maps.event.trigger(this, 'radius_changed');} );

}
//end if circle
//end circle recalculate area--------------------------------------------------------------------------------------------


//end after overlaycomplete listener for area change###########################################################################


//get lat/lng array of the current shape
//var locations = event.overlay.getPath().getArray();
//alert(locations);

//var area=event.overlay.computeArea();
//alert(area);

});
//end area calculate###################################################################

/*google.maps.event.addListener(drawingManager, 'polygoncomplete', function(event){
alert("hi"); 
}); */


/*google.maps.event.addListener(drawingManager, '', function(event) {
alert("hi");
});*/

//end drawing manager.............................................................................................................


}
//end load map................................................................................................................



//display perimeter...........................................................................................................
function display_perimeter(perimeter_meter)
{

//meter
perimeter_meter=perimeter_meter.toFixed(2);
perimeter_meter_display=perimeter_meter+" meter";
//feet
perimeter_feet=perimeter_meter*3.28084;
perimeter_feet_display=perimeter_feet.toFixed(2)+" feet";
//yards
perimeter_yards=perimeter_meter*1.09361;
perimeter_yards_display=perimeter_yards.toFixed(2)+" yards";

//
var perimeter_display=perimeter_feet_display+"<br/>"+perimeter_yards_display+"<br/>"+perimeter_meter_display;
document.getElementById("container_display_perimeter").innerHTML=perimeter_display;

}
//end display perimeter...........................................................................................................




//end display area...............................................................................................................
function display_area(area_meter_square)
{

var str='2';
//meter
area_meter_square=area_meter_square.toFixed(2);
area_meter_display=area_meter_square+" meter"+str.sup();
//feet
area_feet_square=area_meter_square*10.7639;
area_feet_display=area_feet_square.toFixed(2)+" feet"+str.sup();
//yards
area_yards_square=area_meter_square*1.19599;
area_yards_display=area_yards_square.toFixed(2)+" yards"+str.sup();
//acre
area_acre_square=area_meter_square/4046.856;
area_acre_display=area_acre_square.toFixed(2)+" acre";
//hectare
area_hectare_square=area_meter_square*0.0001;
area_hectare_display=area_hectare_square.toFixed(2)+" hectare";

//
var area_display=area_feet_display+"<br/>"+area_yards_display+"<br/>"+area_acre_display+"<br/>"+area_hectare_display+"<br/>"+area_meter_display;
document.getElementById("container_display_area").innerHTML=area_display;

}
//end display area...............................................................................................................




//-----------------------------------------------------------------------------------------------------------------------------
function predefined_circle(radius)
{

var circle = new google.maps.Circle({
center: map.getCenter(),
radius: radius,
fillColor: '#000000',
fillOpacity: 0.3,
strokeColor: 'yellow',
strokeWeight: 1,
editable: true,
clickable: true,
zIndex: 1
});

circle.setMap(map);

//.......................................................................
markersArray.push(circle);
google.maps.event.addListener(circle,"click",function(){});
//.......................................................................

//
area_meter_square = Math.PI*radius*radius;
perimeter_meter = 2*Math.PI*radius;

//area
display_area(area_meter_square);
display_perimeter(perimeter_meter);

//disable draw tool
//rectangle.setDrawingMode(null);
drawingManager.setDrawingMode(null);
//Here the new code
//var new_shape = rectangle.overlay;

//alert(event.type);

//circle recalculate area radius_changed------------------------------------------------------------------------------------------------
google.maps.event.addListener(circle, "radius_changed", function() {
//
radius=circle.getRadius();
area_meter_square = Math.PI*radius*radius;
perimeter_meter = 2*Math.PI*radius;
//

//area
display_area(area_meter_square);
display_perimeter(perimeter_meter);

});

//when clicked call bounds_changed
google.maps.event.addListener(circle, 'click', function(){
                              google.maps.event.trigger(this, 'radius_changed');} );
//end circle recalculate area--------------------------------------------------------------------------------------------


}
//end predefined_circle---------------------------------------------------------------------------------------------------




//-----------------------------------------------------------------------------------------------------------------------------
//in meters
function predefined_semi_circle(radius)
{

//from center of the map startpoint to the left and endpoint to the right to be calculated for drawing the arc

//1 degree=364320 feet
//1 meter=3.28084 feet
//1 degree=111044.73 meters
var width_degree=radius/111044.73;
//alert("width_degree: "+width_degree); return;

var mylat = map.getCenter().lat(); 
var mylng = map.getCenter().lng();
//alert(mylat+', '+mylng); return

//
var startlat=mylat;
var startlng=mylng-width_degree;
var endlat=mylat;
var endlng=mylng+width_degree;

//for semi-circle
/*var centerPoint = {mylat, mylng};
var startPoint = {lat: startlat, lng: startlng};
var endPoint = {lat: endlat, lng: endlng};

//
var startPoint = new google.maps.LatLng(startlat, startlng);
var endPoint = new google.maps.LatLng(endlat,endlng);
var centerPoint = new google.maps.LatLng(mylat, mylng);

//var arcPts = drawArc(centerPoint, centerPoint.Bearing(startPoint), centerPoint.Bearing(endPoint), centerPoint.distanceFrom(startPoint));
var arcPts = drawArc(centerPoint, 0, 180,radius);
*/


/*var piePoly = new google.maps.Polygon({
             paths: [arcPts],
             strokeColor: "#00FF00",
             strokeOpacity: 0.5,
             strokeWeight: 2,
             fillColor: "#FF0000",
             fillOpacity: 0.35,
             map: map
 });*/

//for diameter 
var triangleCoords = [
  {lat: startlat, lng: startlng},
  {lat: mylat, lng: mylng},
  {lat: endlat, lng: endlng}
];

// Define a semi_circle and set its editable property to true.
var semi_circle = new google.maps.Polygon({
paths: triangleCoords/* [arcPts]*/,
fillColor: '#000000',
fillOpacity: 0.3,
strokeColor: 'yellow',
strokeWeight: 1,
editable: true,
clickable: true,
zIndex: 1
});

semi_circle.setMap(map);

//return;

//.......................................................................
markersArray.push(semi_circle);
google.maps.event.addListener(semi_circle,"click",function(){});
//.......................................................................

//return;

//
area_meter_square = google.maps.geometry.spherical.computeArea(semi_circle.getPath());
perimeter_meter = google.maps.geometry.spherical.computeLength(semi_circle.getPath());

//area
display_area(area_meter_square);
display_perimeter(perimeter_meter);

//return;

//disable draw tool
//semi_circle.setDrawingMode(null);
drawingManager.setDrawingMode(null);
//Here the new code
//var new_shape = semi_circle.overlay;

//alert(event.type);

//semi_circle recalculate area------------------------------------------------------------------------------------------------
google.maps.event.addListener(semi_circle, "mouseup", function() {
//
area_meter_square = google.maps.geometry.spherical.computeArea(semi_circle.getPath());
perimeter_meter = google.maps.geometry.spherical.computeLength(semi_circle.getPath());
//

//area
display_area(area_meter_square);
display_perimeter(perimeter_meter);

});
//end semi_circle recalculate area--------------------------------------------------------------------------------------------


}
//end predefined_semi_circle---------------------------------------------------------------------------------------------------




//-----------------------------------------------------------------------------------------------------------------------------
//in meters
function predefined_triangle(width,height)
{

//from center of the map half the distance has to be calculated to the north, to the east and to the west for triangle coords
width=width/2;
height=height/2;
//alert(width+', '+height); return;

//1 degree=364320 feet
//1 meter=3.28084 feet
//1 degree=111044.73 meters
var width_degree=width/111044.73;
var height_degree=height/111044.73;
//alert("width_degree: "+width_degree+", height_degree: "+height_degree); return;

var mylat = map.getCenter().lat(); 
var mylng = map.getCenter().lng();
//alert(mylat+', '+mylng);

var north_lat=mylat+height_degree;
var north_lng=mylng;
var east_lat=mylat-height_degree;
var east_lng=mylng+height_degree;
var west_lat=mylat-height_degree;
var west_lng=mylng-height_degree;

// Define the LatLng coordinates for the polygon's path. Note that there's
// no need to specify the final coordinates to complete the polygon, because
// The Google Maps JavaScript API will automatically draw the closing side.
var triangleCoords = [
  {lat: north_lat, lng: north_lng},
  {lat: east_lat, lng: east_lng},
  {lat: west_lat, lng: west_lng}
];

// Define a triangle and set its editable property to true.
var triangle = new google.maps.Polygon({
paths: triangleCoords,
fillColor: '#000000',
fillOpacity: 0.3,
strokeColor: 'yellow',
strokeWeight: 1,
editable: true,
clickable: true,
zIndex: 1
});

triangle.setMap(map);

//.......................................................................
markersArray.push(triangle);
google.maps.event.addListener(triangle,"click",function(){});
//.......................................................................

//return;

//
area_meter_square = google.maps.geometry.spherical.computeArea(triangle.getPath());
perimeter_meter = google.maps.geometry.spherical.computeLength(triangle.getPath());

//area
display_area(area_meter_square);
display_perimeter(perimeter_meter);

//return;

//disable draw tool
//triangle.setDrawingMode(null);
drawingManager.setDrawingMode(null);
//Here the new code
//var new_shape = triangle.overlay;

//alert(event.type);

//triangle recalculate area------------------------------------------------------------------------------------------------
google.maps.event.addListener(triangle, "mouseup", function() {
//
area_meter_square = google.maps.geometry.spherical.computeArea(triangle.getPath());
perimeter_meter = google.maps.geometry.spherical.computeLength(triangle.getPath());
//

//area
display_area(area_meter_square);
display_perimeter(perimeter_meter);

});
//end triangle recalculate area--------------------------------------------------------------------------------------------


}
//end predefined_triangle---------------------------------------------------------------------------------------------------




//-----------------------------------------------------------------------------------------------------------------------------
function predefined_rectangle(width,height)
{

//from center of the map half the distance has to be calculated to the north, south, to the east and to the west for rectangle coords
width=width/2;
height=height/2;
//alert(width+', '+height); return;

//1 degree=364320 feet
//1 meter=3.28084 feet
//1 degree=111044.73 meters
var width_degree=width/111044.73;
var height_degree=height/111044.73;
//alert("width_degree: "+width_degree+", height_degree: "+height_degree); return;

var mylat = map.getCenter().lat(); 
var mylng = map.getCenter().lng();
//alert(mylat+', '+mylng);

var north=mylat+height_degree;
var south=mylat-height_degree;
var east=mylng+width_degree;
var west=mylng-width_degree;

//alert(north+', '+south+', '+east+', '+west);

var bounds = {
  north: north,
  south: south,
  east: east,
  west: west
};

// Define a rectangle and set its editable property to true.
var rectangle = new google.maps.Rectangle({
bounds: bounds,
fillColor: '#000000',
fillOpacity: 0.3,
strokeColor: 'yellow',
strokeWeight: 1,
editable: true,
clickable: true,
zIndex: 1
});

rectangle.setMap(map);

//.......................................................................
markersArray.push(rectangle);
google.maps.event.addListener(rectangle,"click",function(){});
//.......................................................................

//
var bounds = rectangle.getBounds();
var sw = bounds.getSouthWest();
var ne = bounds.getNorthEast();
var southWest = new google.maps.LatLng(sw.lat(), sw.lng());
var northEast = new google.maps.LatLng(ne.lat(), ne.lng());
var southEast = new google.maps.LatLng(sw.lat(), ne.lng());
var northWest = new google.maps.LatLng(ne.lat(), sw.lng());
var area_meter_square=google.maps.geometry.spherical.computeArea([northEast, northWest, southWest, southEast]);
var perimeter_meter=google.maps.geometry.spherical.computeLength([northEast, northWest, southWest, southEast]);

//area
display_area(area_meter_square);
display_perimeter(perimeter_meter);

//disable draw tool
//rectangle.setDrawingMode(null);
drawingManager.setDrawingMode(null);
//Here the new code
//var new_shape = rectangle.overlay;

//alert(event.type);

//rectangle recalculate area bounds_changed------------------------------------------------------------------------------------------------
google.maps.event.addListener(rectangle, "bounds_changed", function() {
//
var bounds = rectangle.getBounds();
var sw = bounds.getSouthWest();
var ne = bounds.getNorthEast();
var southWest = new google.maps.LatLng(sw.lat(), sw.lng());
var northEast = new google.maps.LatLng(ne.lat(), ne.lng());
var southEast = new google.maps.LatLng(sw.lat(), ne.lng());
var northWest = new google.maps.LatLng(ne.lat(), sw.lng());
var area_meter_square=google.maps.geometry.spherical.computeArea([northEast, northWest, southWest, southEast]);
var perimeter_meter=google.maps.geometry.spherical.computeLength([northEast, northWest, southWest, southEast]);
//

//area
display_area(area_meter_square);
display_perimeter(perimeter_meter);

});

//when clicked call bounds_changed
google.maps.event.addListener(rectangle, 'click', function(){
                              google.maps.event.trigger(this, 'bounds_changed');} );
//end rectangle recalculate area--------------------------------------------------------------------------------------------


}
//end predefined_rectangle---------------------------------------------------------------------------------------------------




//----------------------------------------------------------------------------------------------------------------------------
function clear_overlays()
{

for (var i = 0; i < markersArray.length; i++ ) 
{
    markersArray[i].setMap(null);
}

markersArray.length = 0;

}
//----------------------------------------------------------------------------------------------------------------------------



//get address-----------------------------------------------------------------------------------------------------------------
function geocodeAddress(geocoder, resultsMap) {
var address = document.getElementById('address').value;
geocoder.geocode({'address': address}, function(results, status) {
if (status === 'OK') {
resultsMap.setCenter(results[0].geometry.location);
var marker = new google.maps.Marker({
  map: resultsMap,
  position: results[0].geometry.location
});
} else {
alert('Geocode was not successful for the following reason: ' + status);
}
});
}
//end get address-------------------------------------------------------------------------------------------------------------


</script>


<script async defer
src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDTwbEnr61ZMGwD5kC89JULP2gCJpqhYow&libraries=places,drawing,geometry&callback=initMap">
</script>


</body>
</html>